#include <iostream>
#include <vector>
#include<numeric>
#include <algorithm>

using namespace std;

int min_prodavnice(int N, int K, vector<int>& A, vector<int>& X) {
    vector<pair<int, int>> gradovi; // parovi (grad, broj_stanovnika)
    for (int i = 0; i < N; i++) {
        gradovi.push_back({i + 1, X[i]});
    }
    sort(gradovi.begin(), gradovi.end(), [](const pair<int, int>& a, const pair<int, int>& b) {
        return a.second < b.second;
    });

    int pokriveni_stanovnici = 0;
    int broj_prodavnica = 0;

    for (auto& grad : gradovi) {
        if (pokriveni_stanovnici >= accumulate(X.begin(), X.end(), 0) / 2) {
            break;
        }
        if (binary_search(A.begin(), A.end(), grad.first)) {
            continue;
        }

        broj_prodavnica++;
        pokriveni_stanovnici += grad.second;
    }

    if (pokriveni_stanovnici <= accumulate(X.begin(), X.end(), 0) / 2) {
        return -1;
    } else {
        return broj_prodavnica;
    }
}

int main() {
    int N, K;
    cin >> N >> K;

    vector<int> A(K);
    for (int i = 0; i < K; i++) {
        cin >> A[i];
    }

    vector<int> X(N);
    for (int i = 0; i < N; i++) {
        cin >> X[i];
    }

    cout << min_prodavnice(N, K, A, X) << endl;

    return 0;
}